<?php
/**
 * Topic专题管理模型
 */
class Topic_Model extends Model {
	
	public function __construct() {
		parent::__construct();
	}	

	public function search($where, $limit = '0, 10', $order = 'tid', $by = 'DESC') {
		if (!isset($where['status'])) {
			$where['status'] = 1;	
		}
		if ($where['status'] < 0) {
			unset($where['status']);	
		}
		$res = $this->db->table('#@_topic')
					->field('tid, oid, status, name, eng_name, stpl, stitle, skeywords, sdescription, cover, content')->where($where)
					->limit($limit)
					->order($order.' '.$by)
					->getAll();
		foreach ($res as &$value) {
			$value = $this->getVo($value);	
		}
		unset($value);
		return $res;
	}

	public function getList() {
		$cacheKey = 'topic_list';
		if ($cacheData = $this->cache->getFromBox($cacheKey)) {
			return $cacheData;	
		}
		if ($cacheData = $this->cache->getFromFile($cacheKey)) {
			return $cacheData;	
		}
		$res = $this->db->table('#@_topic')->order('oid, tid DESC')->getAll('tid');
		foreach ($res as &$value) {
			$value = $this->getVo($value);
		}
		unset($value);
		$this->cache->setToFile($cacheKey, $res);
		$this->cache->setToBox($cacheKey, $res);
		return $res;	
	}	
	
	public function getVo($value) {
		$value['url'] = $this->getUrl($value);
		return $value;
	}
	
	public function get($tid) {
		$topicList = $this->getList();
		return isset($topicList[$tid]) ? $topicList[$tid] : null;	
	}
	
	public function del($tid) {
		$this->db->table('#@_topic')->where("tid = $tid")->delete();
	}
	
	public function getUrl($topicInfo, $page = 0) {
		//判断是否有内容
		if ($topicInfo) {
			$tid = $topicInfo['tid'];
			$topic = $this->getOne($tid);
			$eng_name = $topic['eng_name'];
			if (Wee::$config['url_html_topic']) {
				$url = Wee::$config['web_url'] . $this->_getName($topicInfo, $page);
			} else {
				if (Wee::$config['url_mode'] == '2' && $eng_name !='') {
					if ($page > 1) {
						$url = Wee::$config['web_url'] . Wee::$config['url_route_rule_topic'] .'-'. $eng_name . '-' . $page . Wee::$config['url_suffix'];
					} else {
						$url = Wee::$config['web_url'] . Wee::$config['url_route_rule_topic'] .'-'. $eng_name . Wee::$config['url_suffix'];
					}
				} else {
					if ($page > 1) {
						$url = url('Topic', '', array('tid' => $tid, 'p' => $page));
					} else {
						$url = url('Topic', '', array('tid' => $tid));	
					}
				}
			}
		}else{
			//判断是否生成静态
			if (Wee::$config['url_html_topic']) {
				if ($page > 1) {
					$url = Wee::$config['web_url'] . Wee::$config['url_dir_cate'] .'/topic/index_'.$page . Wee::$config['url_suffix'];
				} else {
					$url = Wee::$config['web_url'] . Wee::$config['url_dir_cate'] .'/topic/index' . Wee::$config['url_suffix'];
				}
			}else{
				//判断是否开启路由
				if (Wee::$config['url_mode']) {
					//判断是否第一页
					if ($page > 1) {
						$page = '_'.$page;
					} else {
						$page = '';
					}
					$url = Wee::$config['web_url'] . 'topic' . $page . Wee::$config['url_suffix'];
				} else {
					$url = Wee::$config['web_url'] . Wee::$config['url_index'] . '?c=Topic&p='.$page;
				}
			}		
		}
		return $url;
	}
		
	public function getPath($topicInfo, $page = 0) {
		return APP_PATH . $this->_getName($topicInfo, $page);
	}
	
	private function _getName($topicInfo, $page = 0) {
		$tid = $topicInfo['tid'];
		if ($tid) {
			$engName = $topicInfo['eng_name'];
			if (!$engName) {
				$engName = 't' . $topicInfo['tid'];	
			}
			$name = "$engName";
			if (Wee::$config['url_dir_cate']) {
				$name = Wee::$config['url_dir_cate'] . '/topic/' . $name;
			} 
		}else{
			$name = Wee::$config['url_dir_cate'] . '/topic/index';
		}
		if ($page > 1) {
			$name .= "_$page";	
		}
		return $name . Wee::$config['url_suffix'];	
	}
		
	public function getOne($tid) {
		$rs = $this->db->table('#@_topic')
					->where("tid = $tid")
					->getOne();
		return $rs;	
	}
	
	public function getCid($eng_name) {
		$rs = $this->db->table('#@_topic')
					->where("eng_name = '$eng_name'")
					->getOne();
		return $rs['tid'];	
	}
	
	public function set($tid, $data) {
		$this->db->table('#@_topic')->where("tid = $tid")->update($data);
	}

	public function getPlace($tid) {
		$topicList = $this->getList();
		if (!isset($topicList[$tid])) {
			return false;	
		}
		$topicInfo = $topicList[$tid];
		return $topicInfo;
	}
	
	public function getTotal($where) {
		$res = $this->db->table('#@_topic')
				->field("COUNT(*) AS num")
				->where($where)
				->getOne();
		return $res['num'];
	}
	
	public function getAll($where, $limit = '0, 10', $order = 'id', $by = 'DESC') {
		$res = $this->db->table('#@_topic')
			->where($where)
			->limit($limit)
			->order("$order $by")
			->getAll();
		foreach ($res as &$value) {
			$value = $this->getVo($value);
		}
		return $res;	
	}
	
}